/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCoreFileNameConsistency {
    private final String CORE_PATTERN_CMD = "/bin/cat /proc/sys/kernel/core_pattern";
    private final String CORE_USES_PID_CMD = "/bin/cat /proc/sys/kernel/core_uses_pid";
    private final String PID = "%p";

    sTaskCoreFileNameConsistency() {
    }

    public void checkCoreFileNameConsitency(String[] nodeList, ResultSet rsltSet, Hashtable node_pattern) {
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.runGenericCmd(nodeList, "/bin/cat /proc/sys/kernel/core_pattern", rsltSet);
        Hashtable rsltTab = rsltSet.getResultTable();
        Enumeration e = rsltTab.keys();
        while (e.hasMoreElements()) {
            String token = "";
            String node = (String)e.nextElement();
            Result result = (Result)rsltTab.get(node);
            if (result.getStatus() != 1) continue;
            String output = new String();
            output = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
            if ((output = output.trim()) != null && output.length() > 0) {
                if (output.indexOf("%p") == -1) {
                    Result noderesult = this.isPIDUsed(node);
                    if (noderesult.getStatus() == 1) {
                        String op = new String();
                        op = VerificationUtil.fetchVerificationValue((String)noderesult.getResultInfoSet().firstElement());
                        if ((op = op.trim()) != null || op.length() > 0) {
                            if (op.equals("1")) {
                                output = output + "." + "%p";
                            }
                            if (Trace.isLevelEnabled((int)1)) {
                                Trace.out((String)("Core Uses PID Val= " + op + "  Node " + node));
                            }
                        }
                    } else {
                        result.setStatus(2);
                    }
                }
                token = output;
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Core Pattern on " + token + "  Node " + node));
            }
            VerificationUtil.updateResultMap(node_pattern, token, node);
        }
    }

    Result isPIDUsed(String node) {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet rsltSet = new ResultSet();
        boolean retVal = false;
        globalExec.runGenericCmd(new String[]{node}, "/bin/cat /proc/sys/kernel/core_uses_pid", rsltSet);
        Hashtable rsltTab = rsltSet.getResultTable();
        Result result = (Result)rsltTab.get(node);
        return result;
    }
}

